//
//  RMLiveViewAsynchronousBlockOperation.h
//  AnalogKit
//
//  Created by Keith Duncan on 28/01/2013.
//  Copyright (c) 2013 Realmac Software. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "RMCoreConcurrency/NSOperation+RMCoreConcurrencyAdditions.h"

/*!
	\brief
	Technically the block isn't asynchronous but it should wrap an API that otherwise doesn't have completion notification
	This aids in making subsequent work dependent on API such as the AssetsLibrary on iOS
	
	This should be used as a transitional aid or a legacy/poorly designed API wrapper,
	Typically you should use a promise operation or a genuinely asynchronous -isConcurrent operation
 */
@interface RMAsynchronousBlockOperation : NSOperation

typedef void (^RMAsynchronousBlock)(void (^reacquirer)(RMCoreConcurrencyCompletionProvider completionProvider));

+ (instancetype)asynchronousTaskOperationWithBlock:(RMAsynchronousBlock)block;

@end
